<!-- resources/views/installer/app.blade.php -->
@extends('installer.layout')

@section('title', 'Application')
@section('subtitle', 'Configure your application settings')

@section('content')
    <h2 style="margin-bottom: var(--spacing-lg); color: var(--white);">Application Settings</h2>
    
    <p style="margin-bottom: var(--spacing-lg);">
        Configure the basic settings for your application. These settings can be changed later through your .env file.
    </p>
    
    <form action="{{ route('installer.set_app') }}" method="POST">
        @csrf
        
        <div class="form-group">
            <label for="app_name" class="form-label">
                <i class="fas fa-tag" style="margin-right: var(--spacing-xs); color: var(--primary-color);"></i>
                Application Name
            </label>
            <input type="text" id="app_name" name="app_name" class="form-control" value="{{ old('app_name', 'My Application') }}" required>
            @if($errors->has('app_name'))
                <div style="color: var(--danger); margin-top: var(--spacing-xs); font-size: 0.9rem;">
                    {{ $errors->first('app_name') }}
                </div>
            @endif
            <div style="font-size: 0.85rem; color: var(--light-gray); margin-top: var(--spacing-xs);">
                This name will be used throughout your application.
            </div>
        </div>
        
        <div class="form-group">
            <label for="app_url" class="form-label">
                <i class="fas fa-globe" style="margin-right: var(--spacing-xs); color: var(--primary-color);"></i>
                Application URL
            </label>
            <input type="url" id="app_url" name="app_url" class="form-control" value="{{ old('app_url', url('/')) }}" required>
            @if($errors->has('app_url'))
                <div style="color: var(--danger); margin-top: var(--spacing-xs); font-size: 0.9rem;">
                    {{ $errors->first('app_url') }}
                </div>
            @endif
            <div style="font-size: 0.85rem; color: var(--light-gray); margin-top: var(--spacing-xs);">
                The URL where your application is hosted (e.g., https://example.com).
            </div>
        </div>
        
        <div style="margin-top: var(--spacing-xl); margin-bottom: var(--spacing-lg);">
            <h3 style="color: var(--white); font-size: 1.2rem; margin-bottom: var(--spacing-md);">
                <i class="fab fa-steam" style="margin-right: var(--spacing-xs); color: var(--primary-color);"></i>
                Steam Authentication
            </h3>
            <div style="background-color: rgba(75, 139, 255, 0.1); padding: var(--spacing-md); border-radius: var(--border-radius-md); margin-bottom: var(--spacing-lg); border: 1px solid rgba(75, 139, 255, 0.2);">
                <p style="margin-bottom: var(--spacing-sm); font-size: 0.9rem;">
                    The application supports Steam login. The callback URL will be automatically set based on your Application URL.
                </p>
            </div>
        </div>
        
        <div class="form-group">
            <label for="steam_client_secret" class="form-label">
                <i class="fas fa-key" style="margin-right: var(--spacing-xs); color: var(--primary-color);"></i>
                Steam Client Secret
            </label>
            <input type="text" id="steam_client_secret" name="steam_client_secret" class="form-control" value="{{ old('steam_client_secret') }}" required>
            @if($errors->has('steam_client_secret'))
                <div style="color: var(--danger); margin-top: var(--spacing-xs); font-size: 0.9rem;">
                    {{ $errors->first('steam_client_secret') }}
                </div>
            @endif
            <div style="font-size: 0.85rem; color: var(--light-gray); margin-top: var(--spacing-xs);">
                Your Steam API secret key obtained from the <a href="https://steamcommunity.com/dev/apikey">Steam Developer Portal.</a>
            </div>
        </div>
    @endsection

    @section('footer')
        <a href="{{ route('installer.database') }}" class="btn">
            <i class="fas fa-arrow-left"></i> Back
        </a>
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Save Settings
        </button>
    </form>
@endsection